// JavaScript Document
$(function() {
	// 開いているhtmlファイル名を取得
	var fileName = window.location.href.split('/').pop();
	// ファイル名から言語を特定
	var lang = fileName.split('.')[0];
	lang = lang.split('_').pop();

	var hiraganaMode = false;
	if(lang == "hiragana") {
		hiraganaMode = true;
		lang = "jp";
	}
	lang = getKey("lang");
	
	// ファイルの種類 (list* | list_doc*)
	var sort = fileName.split('.')[0];
	sort = sort.split('_')[1] == "doc" ? "doc" : "";

	// xmlからファイルの有無を確認
	$.ajax({
		url: "text_list_" + lang + ".xml",
		async: false,
		cache: false,
		dataType: "xml",
		error: function(){
			alert("Error loading XML document");
		},
		success: parseXml
	});

	
	if(lang == "ko") {
		//var movie = document.getElementsByClassName("movie");
		//$(movie).find("a").text("[動画]");
		//var pdf = document.getElementsByClassName("doc");
		//$(pdf).find("a").text("[組み立て]");
		var TDs = document.getElementsByTagName("td");
		$(TDs).each(function() {
			if($(this).attr("class") == "movie") {
				$(this).find("a").text("동영상");
			}else if($(this).attr("class") == "doc") {
				$(this).find("a").text("조립 설명서");
				var linkText = $(this).find("a").attr("href");
				$(this).find("a").attr("href", "pdf/" + lang + "/" + linkText);
			}
		});
	}
	


	// XMLパース用関数
	function parseXml(xml, status){
		if(status!='success')return;
		
		$(xml).find("item").each(function() {
			// 作例タイトル
			var id = $(this).attr("id");
			var title = $(this).find("title").text();
			var myDom = document.getElementById(id);
			$(myDom).find(".title").text(title);

		    // プログラム名
			$(this).find("program").each(function() {
				var type = $(this).attr("type");
				var seq = $(this).attr("seq");
				var name = $(this).text();
				var stex = ".link." + type + ".n" + seq;
				$(myDom).find(".programs").find(stex).find("a").text(name);
			});

		});
	}
});

function getKey(key){
	var str = location.search.substring(1);
	if(str){
		var x = str.split("&");
		for(var i=0; i < x.length; i++) {
			var y=x[i].split("=");
			if(y[0] == key) return y[1];
		}
		return "";
	}else {
		return "";
	}
}
